
using Godot;
using Rokojori;
using System.Collections.Generic;
 
namespace Rokojori
{ 
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/UIImage.svg")]
  public partial class SliderUIImageType:UIImageType
  { 
    Dictionary<UIImage,SliderMaterial> _materials = new Dictionary<UIImage, SliderMaterial>();

    static readonly string[] colorProperties = [
      SliderShader.fillColor.propertyName,
      SliderShader.strokeColor.propertyName,
      SliderShader.sliderFillColor.propertyName,
      SliderShader.sliderStrokeColor.propertyName,
    ];

    public override string[] GetColorShaderProperties()
    {
      return colorProperties;
    }

    static readonly string[] numberProperties = [
      SliderShader.borderRadius.propertyName,
      SliderShader.strokeSize.propertyName,
      SliderShader.offset.propertyName,
      SliderShader.sliderStrokeSize.propertyName,     
      SliderShader.sliderSize.propertyName + ".x",
      SliderShader.sliderSize.propertyName + ".y",
      SliderShader.sliderBorders.propertyName
    ];

    public override string[] GetNumberShaderProperties()
    {
      return numberProperties;
    }

    UIColor _fillColor;
    [Export]
    public UIColor fillColor
    {
      get => _fillColor;
      set { _fillColor = value; onChange.DispatchEvent( null ); }
    }

    UIColor _strokeColor;
    [Export]
    public UIColor strokeColor
    {
      get => _strokeColor;
      set { _strokeColor = value; onChange.DispatchEvent( null ); }
    }

    UINumber _borderRadius;
    [Export]
    public UINumber borderRadius
    {
      get => _borderRadius;
      set { _borderRadius = value; onChange.DispatchEvent( null ); }
    }
   
    UINumber _strokeSize;
    [Export]
    public UINumber strokeSize
    {
      get => _strokeSize;
      set { _strokeSize = value; onChange.DispatchEvent( null ); }
    }
   
    UINumber _offset;
    [Export]
    public UINumber offset
    {
      get => _offset;
      set { _offset = value; onChange.DispatchEvent( null ); }
    }

    UINumber _sliderSizeX;
    [Export]
    public UINumber sliderSizeX
    {
      get => _sliderSizeX;
      set { _sliderSizeX = value; onChange.DispatchEvent( null ); }
    }

    UINumber _sliderSizeY;
    [Export]
    public UINumber sliderSizeY
    {
      get => _sliderSizeY;
      set { _sliderSizeY = value; onChange.DispatchEvent( null ); }
    }

    UINumber _sliderBorderRadius;
    [Export]
    public UINumber sliderBorderRadius
    {
      get => _sliderBorderRadius;
      set { _sliderBorderRadius = value; onChange.DispatchEvent( null ); }
    }

    UIColor _sliderFillColor;
    [Export]
    public UIColor sliderFillColor
    {
      get => _sliderFillColor;
      set { _sliderFillColor = value; onChange.DispatchEvent( null ); }
    }

    UIColor _sliderStrokeColor;
    [Export]
    public UIColor sliderStrokeColor
    {
      get => _sliderStrokeColor;
      set { _sliderStrokeColor = value; onChange.DispatchEvent( null ); }
    }

    UINumber _sliderStrokeSize;
    [Export]
    public UINumber sliderStrokeSize
    {
      get => _sliderStrokeSize;
      set { _sliderStrokeSize = value; onChange.DispatchEvent( null ); }
    }

    public override UIColor GetUIStyleColorProperty( UIStyleColorProperty property, string shaderPropertyName )
    {
      if ( SliderShader.fillColor.propertyName == shaderPropertyName )
      {
        return fillColor;
      }

      if ( SliderShader.strokeColor.propertyName == shaderPropertyName )
      {
        return strokeColor;
      }

      if ( SliderShader.sliderFillColor.propertyName == shaderPropertyName )
      {
        return sliderFillColor;
      }

      if ( SliderShader.sliderStrokeColor.propertyName == shaderPropertyName )
      {
        return sliderStrokeColor;
      }

      return null;
    }

     public override UINumber GetUIStyleNumberProperty( UIStyleNumberProperty property, string shaderPropertyName )
    {
      if ( SliderShader.borderRadius.propertyName == shaderPropertyName )
      {
        return borderRadius;
      }

      if ( SliderShader.offset.propertyName == shaderPropertyName )
      {
        return offset;
      }

      if ( SliderShader.sliderSize.propertyName + ".x" == shaderPropertyName )
      {
        return sliderSizeX;
      }

      if ( SliderShader.sliderSize.propertyName + ".y" == shaderPropertyName )
      {
        return sliderSizeY;
      }

      if ( SliderShader.sliderStrokeSize.propertyName == shaderPropertyName )
      {
        return sliderStrokeSize;
      }

      if ( SliderShader.sliderBorders.propertyName == shaderPropertyName )
      {
        return sliderBorderRadius;
      }



      return null;
    }

    protected override void _Assign( UIImage image )
    {
      if ( _materials.ContainsKey( image ) )
      {
        this.LogInfo( "Has Image in cached materials", HierarchyName.Of( image ) );

        if ( image.Material == null )
        {
          this.LogInfo( "Material was null, assigned Image from cached materials" );
          image.Material = _materials[ image ];
        }
        else
        {
          this.LogInfo( "Did not assigned material, already exists" );
        }

        return;
      }
      else
      {
        this.LogInfo( "Image had no material and was not cached, caching & creating material", HierarchyName.Of( image ) );
      }

      _materials[ image ] = new SliderMaterial();

      image.Material = _materials[ image ];
      
    }

    protected override void _Clear( UIImage image )
    {
      if ( image != null && _materials.ContainsKey( image ) && image.Material == _materials[ image ] )
      {
        image.Material = null;
      }

      _materials.Remove( image );
      
    }

    protected override void _Sync( UIImage image )
    {
      // if ( image )
    }

    protected override void _ApplyChange( UIImage image )
    {
      var material = _materials[ image ];

      // AssignColor( image, material.fillColor, _fillColor );
      // // image.CopyColorShaderPropertyFrom( material.fillColor, GetUIColor( _fillColor, image, material.fillColor.propertyName ) );
      // AssignColor( image, material.strokeColor, _strokeColor );


      // image.CopyNumberShaderPropertyFrom( material.borderRadius, _borderRadius, _borderRadiusTransition );
      // image.CopyNumberShaderPropertyFrom( material.strokeSize, _strokeSize, _strokeSizeTransition );
      // image.CopyNumberShaderPropertyFrom( material.offset, _offset, _offsetTransition );
    }


    


  }
}