
using Godot;
using System;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass] 
  public partial class OnSliderValueChange : Node
  { 
    [Export]
    public HSlider slider;
    HSlider _connectedSlider = null;

    [Export]
    public Action onChange;

    public void Update()
    {
      if ( _connectedSlider == slider )
      {
        return;
      }

      if ( _connectedSlider != null )
      {
        _connectedSlider.Changed -= OnChanged;
      }

      _connectedSlider = slider;


       if ( _connectedSlider != null )
      {
        _connectedSlider.Changed += OnChanged;
      }
      
    }

    void OnChanged()
    {
      Action.Trigger( onChange );
    }
  }
}