
using Godot;
using System;

namespace Rokojori
{ 
  public class CachedUIColor
  { 
    public UIStyleColorProperty property;
    public string shaderPropertyName;

    public bool changed;
    public Color defaultColor = Colors.White;
    public Color color;

    
    public static CachedUIColor Create( UIStyleColorProperty colorProperty, string shaderPropertyName = "" )
    {
      var c = new CachedUIColor();
      c.property = colorProperty;
      c.shaderPropertyName = shaderPropertyName;
      c.defaultColor = Colors.White;
      return c;
    }

    public void Compute( Control control )
    {
      var nextValue = UIColor.Compute( control, property, shaderPropertyName, defaultColor );

      changed = color != nextValue;

      if ( changed )
      {
        color = nextValue;
      }
    }
  }
}