
using Godot;
using System;

namespace Rokojori
{ 
  public class CachedUINumber
  { 
    public UIStyleNumberProperty property;
    public string shaderPropertyName;

    public bool isInt = false;
    public float value = 0;
    public int valueInt = 0;
    public bool changed = false;
    public int minInt = -1000000;
    public int maxInt = 1000000;
    
    public CachedUINumber SetMin( int min )
    { 
      minInt = min;
      return this;
    }



    public float alternative;
    public float relative;

    public static CachedUINumber AsFloat( UIStyleNumberProperty numberProperty, string shaderPropertyName = "" )
    {
      var n = new CachedUINumber();
      n.property = numberProperty;
      n.shaderPropertyName = shaderPropertyName;
      n.alternative = 0;
      return n;
    }

    public static CachedUINumber AsInt( UIStyleNumberProperty numberProperty, string shaderPropertyName = "" )
    {
      var n = new CachedUINumber();
      n.property = numberProperty;
      n.shaderPropertyName = shaderPropertyName;
      n.alternative = 0;
      n.isInt = true;

      return n;
    }

    public static CachedUINumber AsInt( string shaderPropertyName )
    {
      return AsInt( UIStyleNumberProperty.FloatShaderProperty, shaderPropertyName );
    }

    public void Compute( Control control )
    {
      var nextValue = UINumber.Compute( control, property, shaderPropertyName, alternative, relative );

      if ( isInt )
      {
        var nextInt = Mathf.Max( minInt, Mathf.RoundToInt( nextValue ) );
        changed = nextInt != valueInt;

        if ( changed )
        {
          valueInt = nextInt;
        }
        
      }
      else
      {
        changed = value != nextValue;

        if ( changed )
        {
          value = nextValue;
        }
      }

      

    }

  }
}