
using Godot;
using Rokojori;
 
namespace Rokojori
{ 

  [Tool]
  [GlobalClass] 
  public partial class ShaderUIColor : Resource
  { 
    [Export]
    public ColorPropertyName colorPropertyName;

    [Export]
    public UIColor color;

    public void UpdateMaterial( UIStylePropertyContainer container, Material material )
    {
      if ( colorPropertyName == null || color == null )
      {
        return;
      }
      
      var colorValue = UIColor.Compute( container as Control, color, Colors.White );
      colorPropertyName.Set( material, colorValue );
    }

    public override string ToString()
    {
      return RJLog.GetInfo( colorPropertyName, color );
    }
  }
}