
using Godot;
using Rokojori;
 
namespace Rokojori
{ 

  [Tool]
  [GlobalClass] 
  public partial class ShaderUINumber : Resource
  { 
    [Export]
    public FloatPropertyName floatPropertyName;

    [Export]
    public UINumber number;

    // [Export]
    // public TransitionSettings transitionSettings;

    public void UpdateMaterial( UIStylePropertyContainer container, Material material )
    {
      if ( floatPropertyName == null || number == null )
      {
        return;
      }

      var numberValue = UINumber.Compute( container as Control, number, 0f );
      floatPropertyName.Set( material, numberValue );
      
    }

    public override string ToString()
    {
      return RJLog.GetInfo( floatPropertyName, number );
    }
  }
}