
using Godot;
using Rokojori;
 
namespace Rokojori
{ 
  public partial class UIShaderProperties
  { 
    public static void UpdateProperties( UIStylePropertyContainer container, Material material )
    {
      var numbers = container.GetShaderUINumbers();

      if ( numbers != null )
      {
        foreach ( var n in numbers )
        {
          if ( n == null )
          {
            continue;
          }
          
          n.UpdateMaterial( container, material );
        }
      }

      var colors = container.GetShaderUIColors();

      if ( colors != null )
      {
        foreach ( var c in colors )
        {
          if ( c == null )
          {
            continue;
          }

          c.UpdateMaterial( container, material );
        }
      }
    }

    public static void UpdatePropertiesInHierarchy( UIStylePropertyContainer styleContainer, Material material )
    {
      UpdatePropertiesInHierarchy( styleContainer, styleContainer, material );
    }

    public static void UpdatePropertiesInHierarchy( UIStylePropertyContainer styleContainer, UIStylePropertyContainer materialContainer, Material material )
    {
      var parent = styleContainer.GetUIStyleParent();

      if ( parent != null )
      {
        UpdatePropertiesInHierarchy( parent, materialContainer, material );
      }

      UpdatePropertiesWith( styleContainer, materialContainer, material );
    }

    public static void UpdatePropertiesWith( UIStylePropertyContainer styleContainer, UIStylePropertyContainer materialContainer, Material material )
    {
      var numbers = styleContainer.GetShaderUINumbers();

      if ( numbers != null )
      {
        foreach ( var n in numbers )
        {
          if ( n == null )
          {
            continue;
          }
          
          n.UpdateMaterial( materialContainer, material );
        }
      }

      var colors = styleContainer.GetShaderUIColors();

      if ( colors != null )
      {
        foreach ( var c in colors )
        {
          if ( c == null )
          {
            continue;
          }

          c.UpdateMaterial( materialContainer, material );
        }
      }
    }
  }
}