
using Godot;
using Rokojori;
 
namespace Rokojori
{ 
  [Tool]
  [GlobalClass] 
  public partial class UICursor : Resource
  { 
    [Export]
    public Control.CursorShape cursorShape = Control.CursorShape.PointingHand;

    public void ApplyCursor( Control control )
    { 
      control.MouseDefaultCursorShape = cursorShape;
    }

    public void ClearCursor( Control control )
    {
      control.MouseDefaultCursorShape = Control.CursorShape.Arrow;
    }
  }
}