
using Godot;
using Rokojori;
using System.Collections.Generic;

namespace Rokojori
{ 

  [Tool]
  [GlobalClass] 
  public partial class UISelectorFlag:SelectorFlag
  {
    public static readonly string selectorsPath = "res://addons/rokojori_action_library/Runtime/UI/UI-Selectors/";

    public static CachedResource<UISelectorFlag> CreateCached( string selector )
    {
      var path = selectorsPath + "UI " + selector + " Selector Flag.tres";

      return new CachedResource<UISelectorFlag>( path );
    } 

    readonly static CachedResource<UISelectorFlag> HoverCached = CreateCached( "Hover" );
    public static UISelectorFlag Hover => HoverCached.Get();

    readonly static CachedResource<UISelectorFlag> DraggingCached = CreateCached( "Dragging" );
    public static UISelectorFlag Dragging => DraggingCached.Get();

    readonly static CachedResource<UISelectorFlag> ScrollingCached = CreateCached( "Scrolling" );
    public static UISelectorFlag Scrolling => ScrollingCached.Get();

    readonly static CachedResource<UISelectorFlag> FocusCached = CreateCached( "Focus" );
    public static UISelectorFlag Focus => FocusCached.Get();

    readonly static CachedResource<UISelectorFlag> ActiveCached = CreateCached( "Active" );
    public static UISelectorFlag Active => ActiveCached.Get();


    public readonly static List<UISelectorFlag> NoFlags = new List<UISelectorFlag>();
  }
}