
using Godot;
using Rokojori;
 
namespace Rokojori
{ 
  public enum UIStyleNumberProperty
  {    
    Left,
    Right,
    Bottom,
    Top,

    Width,
    Height,

    ElementSpacing,
    LineSpacing,
    HorizontalAlignment,
    VerticalAlignment,
    VerticalPlacement,

    Margin,
    MarginLeft,
    MarginRight,
    MarginTop,
    MarginBottom,

    PivotX,
    PivotY,

    Rotation,

    Scale,
    ScaleX,
    ScaleY,

    FontSize,
    FontOutlineSize,
    FontShadowSize,
    FontShadowOffsetX,
    FontShadowOffsetY,

    FloatShaderProperty
  }

  public class UIStyleNumberPropertyAndName
  {
    public UIStyleNumberProperty styleProperty;
    public string shaderPropertyName;

    public static UIStyleNumberPropertyAndName Create( UIStyleNumberProperty property, string shaderPropertyName )
    {
      var pn = new UIStyleNumberPropertyAndName();
      pn.styleProperty = property;
      pn.shaderPropertyName = shaderPropertyName;
      return pn;
    }

    public override string ToString()
    {
      if ( UIStyleNumberProperty.FloatShaderProperty == styleProperty )
      {
        return styleProperty + ": " + shaderPropertyName; 
      }

      return styleProperty + "";
    }

    public bool Matches( UIStyleNumberProperty styleProperty, string shaderPropertyName )
    {
      if ( this.styleProperty != styleProperty )
      {
        return false;
      }

      if ( UIStyleNumberProperty.FloatShaderProperty != styleProperty )
      {
        return true;
      }

      return shaderPropertyName == this.shaderPropertyName;
    }
  
  }

  public enum UIStyleColorProperty
  {
    FontColor,
    FontOutlineColor,
    FontShadowColor,

    ModulationColor,
    SelfModulationColor,

    ColorShaderProperty
  }

  public class UIStyleColorPropertyAndName
  {
    public UIStyleColorProperty styleProperty;
    public string shaderPropertyName;

    public static UIStyleColorPropertyAndName Create( UIStyleColorProperty property, string shaderPropertyName )
    {
      var pn = new UIStyleColorPropertyAndName();
      pn.styleProperty = property;
      pn.shaderPropertyName = shaderPropertyName;
      return pn;
    }

    public override string ToString()
    {
      if ( UIStyleColorProperty.ColorShaderProperty == styleProperty )
      {
        return styleProperty + ": " + shaderPropertyName; 
      }

      return styleProperty + "";
    }

    public bool Matches( UIStyleColorProperty styleProperty, string shaderPropertyName )
    {
      if ( this.styleProperty != styleProperty )
      {
        return false;
      }

      if ( UIStyleColorProperty.ColorShaderProperty != styleProperty )
      {
        return true;
      }

      return shaderPropertyName == this.shaderPropertyName;
    }
  }


}