
using Godot;
using Rokojori;
using System.Collections.Generic;
 
namespace Rokojori
{ 
  public interface UIStylePropertyContainer
  {
    UIStyle GetUIStyleParent();
    void SetUIStyleParent( UIStyle uiStyle );

    UIPosition GetUIPosition();
    UILayout GetUILayout();
    UILineWrap GetUILineWrap();
    UICursor GetHoverCursor( UIStylePropertyContainer container );


    Vector2 GetUISize();

    Font GetFont();
    
    UINumber GetUIStyleNumberProperty( UIStyleNumberProperty property, string shaderPropertyName, UIStylePropertyContainer source );
    void SetUIStyleNumberProperty( UIStyleNumberProperty property, UINumber number );

    UIColor GetUIStyleColorProperty( UIStyleColorProperty property, string shaderPropertyName, UIStylePropertyContainer source );

    ShaderUIColor[] GetShaderUIColors();
    // List<ActiveStyleTransition<UIColor,ColorPropertyName>> GetActiveShaderUIColorTransitions();
    
    ShaderUINumber[] GetShaderUINumbers();
    // List<ActiveStyleTransition<UINumber,FloatPropertyName>> GetActiveShaderUINumberTransitions();

    TransitionSettingsAll GetTransitionSettingsAll();
    UINumberTransition[] GetNumberTransitions();
    List<ActiveStyleTransition<UINumber,UIStyleNumberPropertyAndName>> GetActiveUINumberTransitions();

    UIColorTransition[] GetColorTransitions();
    List<ActiveStyleTransition<UIColor,UIStyleColorPropertyAndName>> GetActiveUIColorTransitions();

    List<UISelectorFlag> GetUISelectorFlags();
    List<UISelectorFlag> GetParentUISelectorFlags();
    void AddUISelectorFlag( UISelectorFlag flag, string reference = "" );
    void RemoveUISelectorFlag( UISelectorFlag flag, string reference = "" );

    public static UIStylePropertyContainer FindInParents( Node n )
    {
      return Nodes.FindInParents<UIStylePropertyContainer>( n );
    }
  }

  public interface UIStylePropertyContainerNode:UIStylePropertyContainer
  {
    public int GetUIAncestorDepth();
    public void ResetDirtyFlags();
    public void SetAnimatedFlag();
    public void SetLayoutDirtyFlag();
    public bool IsDirty();
  }

  public static class UIStylePropertyContainers
  {
    public static void SetDirty( this UIStylePropertyContainerNode container )
    {
      if ( ! ( container is UIHolderControl ) )
      {
        return;
      }

      var control = container as UIHolderControl;

      var ui = control.GetUI();

      if ( ui == null )
      {
        return;
      }
      
      ui.SetDirty( container );
    }

    public static void CommitUpdateInfo( this UIStylePropertyContainerNode container )
    {
      if ( ! ( container is UIHolderControl ) )
      {
        return;
      }

      var control = container as UIHolderControl;

      var ui = control.GetUI();

      if ( ui == null )
      {
        return;
      }
      
      ui.SetUpdated( container );
      
    }

    public static bool HasActiveTransitions( this UIStylePropertyContainer container )
    {
      var animatedNumber = container.GetActiveUINumberTransitions().Find( n => n != null && n.transitioning );
      
      if ( animatedNumber != null )
      {
        return true;
      }

      var animatedColor = container.GetActiveUIColorTransitions().Find( n => n != null && n.transitioning );
      
      if ( animatedColor != null )
      {
        return true;
      }

      return false;
    }
  }

}