
using Godot;
using Rokojori;
 
namespace Rokojori
{ 

  [Tool]
  [GlobalClass] 
  public partial class UIColorTransition : Resource
  { 
    [Export]
    public UIStyleColorProperty property;

    [Export]
    public string shaderPropertyName;

    [Export]
    public TransitionSettings settings;

    public bool Matches( UIStyleColorProperty property, string name )
    {
      var hasSameProperty = this.property == property;

      if ( ! hasSameProperty )
      {
        return false;
      }

      if ( UIStyleColorProperty.ColorShaderProperty != property )
      {
        return true;
      }

      return name == shaderPropertyName;
    }

  }
}