
using Godot;
using Rokojori;
 
namespace Rokojori
{ 

  [Tool]
  [GlobalClass] 
  public partial class UINumberTransition : Resource
  { 
    [Export]
    public UIStyleNumberProperty property;

    [Export]
    public string shaderPropertyName;

    [Export]
    public TransitionSettings settings;

    public bool Matches( UIStyleNumberProperty property, string name )
    {
      var hasSameProperty = this.property == property;

      if ( ! hasSameProperty )
      {
        return false;
      }

      if ( UIStyleNumberProperty.FloatShaderProperty != property )
      {
        return true;
      }

      return name == shaderPropertyName;
    }

  }
}