using Godot;
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/WorldMapLayer.svg")]
  public partial class WorldMapLayer:Node
  {
    [Export]
    public WorldMapLayerType layerType;   
   
    public void Update( WorldMap map )
    {
      layerType.Update( this, map );
    }

    #if TOOLS
    public override void _Ready()
    { 
      this._OnSignal( Node.SignalName.ChildEnteredTree, 
        Callable.From( 
          ( Node node ) =>
          {
            if ( layerType == null )
            {
              return;
            }
            layerType.OnWorldEditorNodeUpdate( WorldMapLayerType.NodeUpdate.Added, this, node );
          } 
        )
      );

      this._OnSignal( Node.SignalName.ChildExitingTree, 
        Callable.From( 
          ( Node node ) =>
          {
            if ( layerType == null )
            {
              return;
            }

            layerType.OnWorldEditorNodeUpdate( WorldMapLayerType.NodeUpdate.Deleted, this, node );
          } 
        )
      );

      this._OnSignal( Node.SignalName.ChildOrderChanged, 
        Callable.From( 
          ( Node node ) =>
          {
            if ( layerType == null )
            {
              return;
            }

            layerType.OnWorldEditorNodeUpdate( WorldMapLayerType.NodeUpdate.Moved, this, node );
          } 
        )
      );
    }

    public override void _Process( double delta )
    {

    }

    #endif


  }
}