using Godot;
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/WorldMapLayer.svg")]
  public abstract partial class WorldMapLayerType:Resource
  {
    [Export]
    public string layerName;
    
    public enum LayerEditType
    {
      Editor_And_Runtime,
      Editor_Only,
      Runtime_Only
    }

    [Export]
    public LayerEditType editType;

    public abstract void Update( WorldMapLayer layer, WorldMap map );

    public enum NodeUpdate
    {
      Added,
      Deleted,
      Moved
    }

    public abstract void OnWorldEditorNodeUpdate( NodeUpdate update, WorldMapLayer mapLayer, Node node );
    
    
    public Vector3 GetPositionOfNode( Node node )
    {
      if ( node is Node3D node3D)
      {
        return node3D.GlobalPosition;
      }

      return Vector3.Zero;
    }

  }
}