using Godot;
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/WorldMap.svg")]
  public partial class WorldMap:Node
  {
    [Export]
    public WorldMapDefinition worldMapDefinition;

    [Export]
    public WorldStreamer[] streamers = [];
    
    List<WorldMapLayer> _layers = [];

    [ExportToolButton( "Initialize Layers" )]
    public Callable initializeLayersButton => Callable.From( ()=> { InitializeLayers(); } );

    public void InitializeLayers()
    {
      foreach ( var ld in worldMapDefinition.layers )
      {
        var layer = this.CreateChild<WorldMapLayer>( ld.layerName );
        layer.layerType = ld;        
      }
    }

    public override void _Process( double delta )
    {
      UpdateLayers();
    }

    public void UpdateLayers()
    {
      _layers.ForEach( l => l.Update( this ) );
    }

   

    


  }
}