using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class XMLAttributeNode:XMLNode
  {
    public XMLAttributeNode( XMLDocument document, XMLElementNode parent, string name, string value, string nameSpace = null ):base( document, XMLNode.NodeType.Attribute )
    {
      _name = name; 
      _nameSpace = nameSpace;
      _value = value;
      _parent = parent;
    }

    XMLElementNode _parent;
    string _name;
    string _nameSpace;
    string _value;    
    string _fullName;

    public string name => _name;
    public string value => _value;
    public string nameSpace => _nameSpace;

    public override string nodeValue => value;

    public string fullName
    {
      get
      {
        if ( _fullName != null )
        {
          return _fullName;
        }

        _fullName = _name;

        if ( _nameSpace != null )
        {
          _fullName = _nameSpace + ":" + _name;
        }
        

        return _fullName;
      }
    }

  }
}