using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using Godot;

namespace Rokojori
{  
  public class SVGPathCommand
  {
    public int pathIndex = -1;
    public string type;
    public List<float> paramaters = new List<float>();

    public static string SVGCoordinate( float x, float y )
    {
      return RegexUtility.NumberToString( x ) + " " + RegexUtility.NumberToString( y );
    }

     public static string SVGCoordinate( Vector2 v )
    {
      return SVGCoordinate( v.X, v.Y );
    }

    public override string ToString()
    {
      if ( type == "z" || type == "Z" )
      {
        if ( paramaters.Count > 0 )
        {
          return "Invalid! " + type + " " + Lists.Join( paramaters, " " );
        }

        return type;
      }

      var pLength = GetParameterLengthForCommand( type );
      var blocks = paramaters.Count / pLength;
      var valid = blocks * pLength == paramaters.Count;

      if ( ! valid )
      {
        return "Invalid! " + type + " " + Lists.Join( paramaters, " " );
      }

      return type + "(" + blocks + ") " + Lists.Join( paramaters, " " );
    }

    public static int GetParameterLengthForCommand( string commandType )
    {
      var ct = commandType.ToLower();

      switch ( ct )
      {
        case "z": return 0;  

        case "h": case "v" : return 1;       

        case "s": case "q": return 4;

        case "c": return 6;

        case "a": return 7;
      }


      return 2;
    }
  }
}