using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class XMLAttributeName:XMLElementSelector
  {
    public static readonly XMLAttributeName id = XMLAttributeName.Create( "id" );

    string _attributeName;
    string _nameSpace;

    string _fullName;

    public string fullName 
    {
      get 
      {
        if ( _fullName != null )
        {
          return _fullName;
        }

        _fullName = _attributeName;

        if ( _nameSpace != null )
        {
          _fullName = _nameSpace + ":" + _attributeName;
        }

        return _fullName;
      }
    }

    public string selector => "[" + fullName +  "]";

    public static XMLAttributeName Create( string type, string nameSpace = null )
    {
      if ( nameSpace == null && type.Contains( ":" ) )
      {
        nameSpace = type.Substring( 0, type.IndexOf( ":" ) );
        type = type.Substring( type.IndexOf( ":" ) + 1 );
      }

      var elementNodeType = new XMLAttributeName();
      elementNodeType._attributeName = type;
      elementNodeType._nameSpace = nameSpace;

      return elementNodeType;
    }

    public XMLAttributeNode GetAttribute( XMLElementNode elementNode )
    {
      return elementNode.GetAttribute( _attributeName, _nameSpace );
    }

    public string Get( XMLElementNode elementNode )
    {
      var atttribute = GetAttribute( elementNode );
      return atttribute == null ? null : atttribute.nodeValue;
    }

    public void Set( XMLElementNode elementNode, string value )
    {
      elementNode.SetAttribute( _attributeName, value, _nameSpace );
    }

    public void RemoveFrom( XMLElementNode elementNode )
    {
      var att = GetAttribute( elementNode );
      elementNode.RemoveAttribute( att );
    }


    public bool Selects( XMLElementNode elementNode )
    {
      return elementNode.GetAttribute( _attributeName, _nameSpace ) != null;
    }

    
  }
}