using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class XMLElementNodeName:XMLElementSelector
  {

    string _nodeName;
    string _nameSpace;

    string _fullName;

    public string fullName 
    {
      get 
      {
        if ( _fullName != null )
        {
          return _fullName;
        }

        _fullName = _nodeName;

        if ( _nameSpace != null )
        {
          _fullName = _nameSpace + ":" + _nodeName;
        }

        return _fullName;
      }
    }

    public string selector => fullName;

    public static XMLElementNodeName Create( string type, string nameSpace = null )
    {
      var elementNodeType = new XMLElementNodeName();
      elementNodeType._nodeName = type;
      elementNodeType._nameSpace = nameSpace;

      return elementNodeType;
    }

    public XMLElementNode Create( XMLDocument document )
    {
      return new XMLElementNode( document, _nodeName );  
    }

    public bool Selects( XMLElementNode elementNode )
    {
      return elementNode.nodeName == _nodeName && elementNode.nameSpace == _nameSpace;
    }

    
  }
}