using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public abstract class XMLNode
  {
    public enum NodeType
    {
      Element = 1,
      Attribute = 2,
      Text = 3,
      CDataSection = 4,
      ProcessingInstruction = 7,
      Comment = 8,
      Document = 9,
      DocumentType = 10,
      DocumentFragment = 11
    } 

    NodeType _nodeType;
    public NodeType nodeType => _nodeType;

    protected XMLDocument _document;
    public XMLDocument document => _document;

    protected XMLNode _parentNode;
    public XMLNode parentNode => _parentNode;
    public XMLElementNode parentElement => _parentNode as XMLElementNode;
    public void _SetParent( XMLNode node )
    {
      _parentNode = node;
    }
    
    public virtual string nodeValue => null;
    public virtual string textContent => "";

    public virtual string GetInfo()
    {
      return nodeType +  ":" + nodeValue;
    }

    public XMLNode( XMLDocument document, NodeType type )
    {
      _document = document;
      _nodeType = type;
    }   

  }
}