using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using Godot;

namespace Rokojori
{  
  public class XMLQuery
  {
    public static XMLElementNode SelectElement( XMLNode node, XMLElementSelector selector )
    {
      var element = XMLWalker.instance.Find( node, 
        n => 
        {          
          var element = n as XMLElementNode;
          
          if ( element == null )
          {
            return false;
          }

          return selector.Selects( element );
        },

        false
      );

      return element == null ? null : ( element as XMLElementNode );
    }

    public static List<XMLElementNode> SelectAllElements( XMLNode node, XMLElementSelector selector )
    {
      var list = new List<XMLElementNode>();

      XMLWalker.instance.Iterate( node, 
        n => 
        {          
          var element = n as XMLElementNode;
          
          if ( element == null )
          {
            return;
          }

          if ( selector.Selects( element ) )
          {
            list.Add( element );
          }
        },

        false
      );

      return list;
    }
  }

}