using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class XMLReaderTest:Node
  {
    [Export]
    public string path;

    [Export]
    public bool loadFile;

    [Export]
    public MeshInstance3D meshInstance3D;

    [Export]
    public bool selectRandom = false;

    [Export]
    public string selectorAttribute;

    [Export]
    public string selectorValue;



    [Export]
    public float resolution;


    [Export]
    public bool autoReload = false;

    [Export]
    public int reloadFrames = 10;

    int reloadCounter = 0;

    public override void _Process( double delta )
    {

      if ( ! loadFile )
      {
        if ( autoReload )
        {
          reloadCounter ++;

          if ( reloadCounter > reloadFrames )
          {
            reloadCounter = 0;
            loadFile = true;
          }
        }
        
        return;
      }

      Load();
    }

    
    string loadedPath = null;
    XMLDocument doc;

    void Load()
    {
      loadFile = false;

      if ( path != loadedPath )
      {   
        var text = FilesSync.LoadUTF8( path );
        var reader = new XMLReader();

        doc = reader.Read( text );
      }
     
      var paths = doc.querySelectorAll( SVGElementName.path );

      XMLElementNode randomPath = null;

      if ( selectRandom )
      {
        randomPath = GodotRandom.Get().From( paths );

      }


      XMLWalker.instance.Iterate( doc, 
        n => 
        { 
          if ( ! ( n is XMLElementNode ) )
          {
            return;
          }

          var e = (XMLElementNode) n;
        }
      );
      

      // RJLog.Log( "Paths in SVG:", paths.Count );

     
      
      var attributeSelector = XMLAttributeName.Create( selectorAttribute );

      paths.ForEach(
        ( p ) =>
        {
          if ( XMLAttributeName.id.Selects( p ) )
          {
            // RJLog.Log( "Processing:", XMLAttributeName.id.Get( p ), attributeSelector.Get( p ), attributeSelector.Get( p ) == selectorValue );
          }          

          var pathData = SVGAttributeName.d.Get( p );

          if ( pathData == null )
          {
            RJLog.Log( "No path data found:", p );
            return;
          } 

          

          if ( randomPath == p || ( randomPath == null && attributeSelector.Selects( p ) && attributeSelector.Get( p ) == selectorValue ) )
          {
            var shape2 = Shape2.FromSVGPath( pathData, resolution );
            
            if ( meshInstance3D != null )
            {
              var meshGeometry = shape2.CreateFillMeshGeometry();

              if ( meshGeometry != null )
              {
                meshInstance3D.Mesh = meshGeometry.GenerateMesh();
              }              
            }

          }

          /*RJLog.Log( "pathData:", pathData );
          var commands = SVGPathParser.Parse( pathData );


          if ( commands != null )
          {           
            RJLog.Log( "Commands:", commands.Count, "\n" + Lists.Join( commands, "\n" ) );

            
            var extractor = new SVGPathExtractor();
            extractor.onInstruction.AddAction(
              ( si )=>
              {
                RJLog.Log( si );
              }
            );
            extractor.Process( commands );
            

          }
          else
          {
             var messages = SVGPathParser.GetMessages( pathData );
            RJLog.Log( "Commands failed parsing:", Lists.Join( messages, "\n" ) );
          }

          */

          
        }
      );

    }
  }
}