using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class XMLWalker: TreeWalker<XMLNode>
  { 
    private static XMLWalker _instance = new XMLWalker();
    public static XMLWalker instance => _instance;

    public override int NumChildren( XMLNode node )
    {
      if ( node is XMLDocument )
      {
        return ( (XMLDocument ) node ).numRoots;
      }

      var elementNode = node as XMLElementNode;

      if ( elementNode != null )
      {
        return elementNode.numChildren;
      }

      return 0;
    }

    public override XMLNode ChildAt( XMLNode node, int index )
    { 
      if ( node is XMLDocument )
      {
        return ( (XMLDocument)node).GetChild( index );
      }

      var elementNode = node as XMLElementNode;

      if ( elementNode != null )
      {
        return elementNode.GetChildAt( index );
      }

      return null;
    }

    public override XMLNode Parent( XMLNode node )
    {
      return node.parentNode;
    }
  }

}