#if TOOLS
using Godot;
using Rokojori;
using System.Diagnostics;
using System.Collections.Generic;
using System.Threading.Tasks;
using System;

namespace Rokojori.Tools
{ 
  [Tool]
  [GlobalClass]
  public partial class GitTest:Node
  {
    [ExportToolButton("Status")]
    public Callable statusButton => Callable.From( 
      ()=>
      {
        GetStatus();
      }
    );

    async void GetStatus()
    {
      var response = await Git.GetStatus( ProjectSettings.GlobalizePath( "res://") );
      this.LogInfo( response.exitCode, ">>", response.rawResponse );      
    }

    [ExportGroup( "File")]
    [Export]
    public string filePath;

    [ExportToolButton("Get Change Time")]
    public Callable changeTimeButton => Callable.From( 
      ()=>
      {
        GetTime();
      }
    );

    async void GetTime()
    {
      var optionalTime = await Git.GetFileChangedTime( ProjectSettings.GlobalizePath( filePath ) );
      
      if ( optionalTime != null )
      {
        var time = (DateTimeOffset) optionalTime;
        this.LogInfo( "LOCAL:", time.ToLocalTime(), "  ||  UTC:", time,"\n>>", filePath );
      }
      else
      {
        this.LogInfo( "Could not receive time info" );      
      }

      
    }

    
  }
}
#endif