
using Godot;
using Rokojori;
using System.Collections.Generic;

namespace Rokojori
{  
  #if !TOOLS

  public interface GizmoDrawer  
  {

  }

  #else
 
  public interface GizmoDrawer  
  {
    void DrawGizmo( EditorNode3DGizmoPlugin gizmoPlugin, EditorNode3DGizmo gizmo );
    
  }

  public interface GizmoDrawerWithHandles:GizmoDrawer
  {
    string GetHandleName( EditorNode3DGizmo gizmo, int handleId, bool secondary );
    Variant GetHandleValue( EditorNode3DGizmo gizmo, int handleId, bool secondary );

    void SetHandle( EditorNode3DGizmo gizmo, int id, bool secondary, Camera3D camera, Vector2 point );
    void CommitHandle( EditorNode3DGizmo gizmo, int id, bool secondary, Variant restore, bool cancel );

    /*

    public string GetHandleName( EditorNode3DGizmo gizmo, int handleId, bool secondary )
    {
      return "";
    }

    public Variant GetHandleValue( EditorNode3DGizmo gizmo, int handleId, bool secondary )
    {
      return Variant.From( 0 );
    }

    public void SetHandle( EditorNode3DGizmo gizmo, int id, bool secondary, Camera3D camera, Vector2 point )
    {

    }

    public void CommitHandle( EditorNode3DGizmo gizmo, int id, bool secondary, Variant restore, bool cancel )
    {

    }
    
    */
  }

  #endif
}