
using Godot;
using Rokojori;
using System.Collections.Generic;

namespace Rokojori
{  
  #if !TOOLS
  [Tool]
  public partial class GizmoDrawerPlugin : Node
  {

  }

  #else 

  [Tool]
  public partial class GizmoDrawerPlugin : EditorNode3DGizmoPlugin
  {
    public GizmoDrawerPlugin()
    {
      CreateMaterial( "main", new Color( 1, 1, 1 , 1 ) );
    }

    public override string _GetGizmoName()
    {
      return "Gizmo Drawer";
    }

    public override bool _HasGizmo( Node3D node )
    {
      return node is GizmoDrawer;
    }

    public override void _Redraw( EditorNode3DGizmo gizmo )
    {
      var gizmoDrawer = gizmo.GetNode3D() as GizmoDrawer;
      
      if ( gizmoDrawer == null )
      {
        return;
      }

      gizmoDrawer.DrawGizmo( this, gizmo );

    }

    public override string _GetHandleName( EditorNode3DGizmo gizmo, int handleId, bool secondary )
    {
      var gizmoDrawerWithHandles = gizmo.GetNode3D() as GizmoDrawerWithHandles;
      
      if ( gizmoDrawerWithHandles == null )
      {
        return null;
      }

      return gizmoDrawerWithHandles.GetHandleName( gizmo, handleId, secondary );
    }

    public override Variant _GetHandleValue( EditorNode3DGizmo gizmo, int handleId, bool secondary )
    {
      var gizmoDrawerWithHandles = gizmo.GetNode3D() as GizmoDrawerWithHandles;
      
      if ( gizmoDrawerWithHandles == null )
      {        
        return Variant.CreateFrom( (string)null );
      }

      return gizmoDrawerWithHandles.GetHandleValue( gizmo, handleId, secondary );
    }


    public override void _SetHandle( EditorNode3DGizmo gizmo, int handle_id, bool secondary, Camera3D camera, Vector2 screen_pos )
    {
      var gizmoDrawerWithHandles = gizmo.GetNode3D() as GizmoDrawerWithHandles;
      
      if ( gizmoDrawerWithHandles == null )
      {        
        return;
      }

      gizmoDrawerWithHandles.SetHandle( gizmo, handle_id, secondary, camera, screen_pos );
    }

    public override void _CommitHandle( EditorNode3DGizmo gizmo, int handle_id, bool secondary, Variant restore, bool cancel )
    {
      var gizmoDrawerWithHandles = gizmo.GetNode3D() as GizmoDrawerWithHandles;
      
      if ( gizmoDrawerWithHandles == null )
      {        
        return;
      }

      gizmoDrawerWithHandles.CommitHandle( gizmo, handle_id, secondary, restore, cancel );
    }
  }

  #endif
}