#if TOOLS
using Godot;
using Rokojori;
using System.Diagnostics;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Rokojori.Tools
{  

  // https://docs.blender.org/api/current/bpy.ops.export_scene.html#bpy.ops.export_scene.fbx
  public class BlenderFBXExportSettings
  {
    public string path_mode = "AUTO";
    public string batch_mode = "OFF";
    public bool embed_textures = true;    
    public bool use_batch_own_dir = false;
    public bool use_metadata = true;
    public bool check_existing = false;

    // INCLUDE
   
    public bool use_selection = false;
    public bool use_visible = false;
    public bool use_active_collection = false;
    public List<string> object_types = new List<string> { "EMPTY","CAMERA","LIGHT","ARMATURE","MESH","OTHER"  };
    public bool use_custom_props = false;

    // TRANSFORM
    public float global_scale = 1.0f;
    public string apply_scale_options = "FBX_SCALE_ALL"; // 'FBX_SCALE_NONE', 'FBX_SCALE_UNITS', 'FBX_SCALE_CUSTOM', 'FBX_SCALE_ALL'
    public string axis_forward = "-Z";
    public string axis_up = "Y";

    public bool apply_unit_scale = false;
    public bool use_space_transform = true;
    public bool bake_space_transform = true;


    // GEOMETRY
    public bool use_mesh_modifiers = true;  // Apply Modifiers
    public bool use_mesh_modifiers_render = false;
    public string mesh_smooth_type = "OFF"; // OFF, FACE, EDGES
    public bool use_subsurf = false;
    public bool use_mesh_edges = false;
    public bool use_tspace = false;
    public bool use_triangles = false;
    public string colors_type = "SRGB"; // NONE, SRGB, LINEAR

    // ARMATURE
   
    public bool add_leaf_bones = false;
    public string primary_bone_axis = "Y";
    public string secondary_bone_axis = "X";
    public string armature_nodetype = "NULL";

    // BAKE ANIMATION
    public bool bake_anim = true;
    public bool bake_anim_use_all_bones = true;
    public bool bake_anim_use_nla_strips = true;
    public bool bake_anim_use_all_actions = true;
    public bool bake_anim_force_startend_keying = true;
    public float bake_anim_step = 1.0f;
    public float bake_anim_simplify_factor = 1.0f;

    
   
  }

  public class BlenderGLTFtoFBX
  {
    
    public static async Task<BlenderResponse> Run( string gltfPath, string fbxPath, BlenderFBXExportSettings fbxSettings = null )
    {
      var pythonPath = RokojoriPlugin.GlobalizedPath( "Tools/blender/gltf_to_fbx.py" );
      
      var tempSettings = fbxSettings == null ? new BlenderFBXExportSettings() : fbxSettings;
      var tempSettingsPath = RokojoriPlugin.SaveTemporaryJSON( tempSettings );

      var conversionArgs = new List<string>();
      conversionArgs.Add( gltfPath.EscapeAsPathForCommandLine() );
      conversionArgs.Add( fbxPath.EscapeAsPathForCommandLine() );
      conversionArgs.Add( tempSettingsPath.EscapeAsPathForCommandLine() );


      var response = await Blender.RunPython( pythonPath, conversionArgs ); 
      
      FilesSync.Delete( tempSettingsPath );

      return response;
    }
  }

}
#endif