#if TOOLS
using Godot;
using Rokojori;
using System.Diagnostics;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Rokojori.Tools
{ 
  [Tool]
  [GlobalClass]
  public partial class BlenderTest:Node
  {
    [Export]
    public string gltfPath;

    [Export]
    public string fbxPath;

    [ExportToolButton("Convert GLTF to FBX")]
    public Callable StatusButton => Callable.From( 
      ()=>
      {
        Convert();
      } 
    );

   
    async void Convert()
    {
      Blender.path = "C:/Program Files/Blender Foundation/Blender 4.0/blender.exe";

      this.LogInfo( "Starting conversion..." );

      var globalGLTFPath = ProjectSettings.GlobalizePath( gltfPath );
      var globalFBXPath  = ProjectSettings.GlobalizePath( fbxPath );

      var settings = new BlenderFBXExportSettings();


      var response = await BlenderGLTFtoFBX.Run( globalGLTFPath, globalFBXPath, settings );
      this.LogInfo( response.exitCode, ">>", response.rawResponse );
      
    }
  }
}
#endif