import bpy
import sys
import json

# Parse CLI arguments
argv = sys.argv
input_path = argv[-3]
output_path = argv[-2]
settings_json_path = argv[-1]

print( argv )
print( input_path )
print( output_path )
print( settings_json_path )

# Reset the scene
bpy.ops.wm.read_factory_settings(use_empty=True)

# Import GLTF/GLB
bpy.ops.import_scene.gltf(filepath=input_path)

# Load FBX export settings from JSON file
with open(settings_json_path, 'r') as f:
    export_settings = json.load(f)

# Convert certain keys to sets (JSON only allows lists)
for key in ['object_types']:
    if key in export_settings and isinstance(export_settings[key], list):
        export_settings[key] = set(export_settings[key])

print( export_settings )
# Export to FBX using settings from JSON
bpy.ops.export_scene.fbx(
    filepath=output_path,
    **export_settings
)