
using System.Collections.Generic;


namespace Rokojori.DocGenerator
{  
  public class ParameterType
  {
    public string name;
    public string type;
    public string csNameSpace;
    public List<string> modifiers = []; 
    public List<string> generics = [];
  }

  public class MemberInfo
  {
    public string doc;
    public string memberType;
    public string name;
    public string dataType;
    public string csNameSpace;
    public string path;
    public bool isAccessor;
    public List<string> attributes = new List<string>();
    public int lineIndex;
    public int lineOffset;

    public List<string> modifiers = new List<string>();
    public List<string> generics;
    public List<ParameterType> parameters = new List<ParameterType>();

    public static readonly string Field = "Field";
    public static readonly string Method = "Method";
    public static readonly string Constructor = "Constructor";
    public static readonly string Uniform = "Uniform";
    public static readonly string Varying = "Varying";

    public static MemberInfo Create( string memberType )
    {
      var m = new MemberInfo();
      m.memberType = memberType;
      return m;  
    }

    public static MemberInfo CreateField()
    {
      return MemberInfo.Create( MemberInfo.Field );
    }

    public static MemberInfo CreateMethod()
    {
      return MemberInfo.Create( MemberInfo.Method );
    }

    public static MemberInfo CreateConstructor()
    {
      return MemberInfo.Create( MemberInfo.Constructor );
    }

    public static MemberInfo CreateUniform()
    {
      return MemberInfo.Create( MemberInfo.Uniform );
    }

    public static MemberInfo CreateVarying()
    {
      return MemberInfo.Create( MemberInfo.Varying );
    }
  }

  public class ClassDocInfo
  {
    public string csNameSpace = "";
    public string name ="";
    public string doc;
    public string icon;
    public string sourcePath;
    public string definitionType;
    public ISOTimeStamp modificationTime;
        
    public List<string> generics = new List<string>();
    public List<string> interfaces = new List<string>();
    public List<string> extendingClasses = new List<string>();
    public List<MemberInfo> memberInfos = new List<MemberInfo>();

    
  }
}