
using Godot;

using System.Collections.Generic;
using System;

namespace Rokojori.DocGenerator
{
  public class SomeArrayClass
  {
    public int index = 2;
    public string value = "Hello World";
  }

  public class SomeClass
  {
    public float x = 0;
    public float GetX()
    {
      return x * 2;
    }

    public List<SomeArrayClass> values = new List<SomeArrayClass>();

  } 

  [GlobalClass][Tool]
  public partial class CreateDoc : Node
  {
    [Export]
    public string outputPath ="res://.rokojori/cache/docs";

    [Export]
    public bool clearDirectory = false;

    [Export]
    public bool c_sharp = true;

    [Export]
    public bool shaders = true;

    [Export]
    public bool processOnlyNewer = true;

    [Export]
    public int hoursCheckTime = 12;

    [ExportToolButton( "Create")]
    public Callable createButton => Callable.From( ()=>{ Generate(); } );

    void Test()
    {
      var obj = new SomeClass();      
      var sa = new SomeArrayClass();
      var sb = new SomeArrayClass();
      sb.value = "Huhu";
      obj.values.Add( sa );
      obj.values.Add( sb );

      var testJSON = JSON.StringifyObject( obj );
      RJLog.Log( testJSON );
    }

    void Generate()
    {  

      var absoluteLibraryPath = ProjectSettings.GlobalizePath( "res://addons/rokojori_action_library/Runtime" );
      var absoluteIconPath    = ProjectSettings.GlobalizePath( "res://addons/rokojori_action_library/Icons" );   
      var absoluteOutputPath  = ProjectSettings.GlobalizePath( outputPath );  

      if ( clearDirectory )
      {
        FilesSync.Delete( absoluteOutputPath );
        FilesSync.EnsureDirectoryExists( absoluteOutputPath );
      }

      var generator = new DocGenerator();
      generator.shaders = shaders;
      generator.cSharp = c_sharp;
      generator.checkChangeTime = processOnlyNewer;

      var icons = Lists.Map( FilesSync.GetFiles( absoluteIconPath, ( fp => fp.fileExtension == ".svg" ) ), fp => fp.fullFileName );
      generator.Generate( absoluteLibraryPath, absoluteOutputPath, icons );
    }
  }
}