
using Godot;

using Rokojori;
using System.Collections.Generic;
using System;
using System.Text.RegularExpressions;
using System.Linq;
namespace Rokojori.DocGenerator
{  
  public static class GetDocsType
  {
    public static bool isAccessorMethod( System.Reflection.MethodInfo m )
    {
      var isSetAccessor = m.DeclaringType.GetProperties().Any( prop => prop.GetSetMethod() == m );
      
      if ( isSetAccessor )
      {
        return true;
      }

      var isGetAccessor = m.DeclaringType.GetProperties().Any( prop => prop.GetGetMethod() == m );

      return isGetAccessor;
    }
    
    public static Dictionary<string,string> replacements = new Dictionary<string, string>()
    {
      { "Int32", "int" },
      { "Single", "float" },
      { "Boolean", "bool" }
    };
    public static string Of( Type type )
    {
      var docType = type.Name;

      if ( replacements.ContainsKey( docType ) )
      {
        docType = replacements[ docType ];
      }
          
      if ( docType.Contains( "Action" ) && type.Namespace.Contains( "System" ) )
      {
        docType = docType.Replace( "Action", "System.Action" );
      }

      if ( docType.Contains( "`" )  )
      {
        var generics = Lists.Map( type.GetGenericArguments(), t => Of( t ) );
        var replacement = "<" + generics.Join( "," ) + ">";
        docType = docType.Replace( new Regex( "`.*$" ), replacement );
      }

      return docType;
    }
  }
}